############################################################
# Use this module to create delegation subdomain NS records
############################################################

terraform {
  required_version = "= 0.12.6"

  backend "s3" {
    region         = "us-west-2"
    bucket         = "live-video-dns-state-tf-state"
    dynamodb_table = "terraform_locks"
  }
}

# Stub us-west-2 since it's a required parameter
provider "aws" {
  region  = "us-west-2"
  version = "~> 2.34.0"
}

# subdomain account
provider "aws" {
  region = "us-west-2"
  alias  = "subdomain"

  assume_role {
    role_arn = "arn:aws:iam::${var.subdomain_account_id}:role/lvs-dns-delegation"
  }
}

provider "null" {
  version = "~> 2.1"
}

locals {
  lvs_route53_id = var.domain_route53_id

  subdomain_name    = "${var.service}.${var.domain}"
  subdomain_comment = "Delegated to ${var.subdomain_account_id} (${var.subdomain_account_name})"
}

data "aws_route53_zone" "subdomain" {
  provider = "aws.subdomain"

  zone_id      = var.subdomain_route53_id
  private_zone = false
}

resource "null_resource" "validate_name" {
  count = "${local.subdomain_name}." == data.aws_route53_zone.subdomain.name ? 0 : "Route53 subdomain name did not match expected <service>.${var.domain}"
}

# Create required subdomain records
resource "aws_route53_record" "subdomain" {
  zone_id = local.lvs_route53_id
  name    = local.subdomain_name
  type    = "NS"
  ttl     = var.ttl

  records = data.aws_route53_zone.subdomain.name_servers
}

# Create a txt entry in route53 to as a way to "store" metadata when viewing DNS records in console.aws.amazon.com
resource "aws_route53_record" "comment" {
  zone_id = local.lvs_route53_id
  name    = "_comment.${local.subdomain_name}"
  type    = "TXT"
  ttl     = var.ttl

  records = [local.subdomain_comment]
}
