# Required variables
variable "service" {
  description = "The name of the service"
}

variable "subdomain_account_id" {
  description = "The account id where the Route53 subdomain lives"
}

variable "subdomain_account_name" {
  description = "The name of the account that this subdomain will be delegated to"
}

variable "subdomain_route53_id" {
  description = "The Route53 zone_id of the subdomain"
}

variable "domain" {
  description = "The top level domain name"
  default     = "live-video.a2z.com"
}

variable "domain_route53_id" {
  description = "The Route53 zone_id of the domain"
  default     = "Z3PBLIDNGDAXPF" # twitch-bs-video-lvs-dns / live-video.a2z.com
}

# Optional variables
variable "ttl" {
  type        = number
  description = "DNS record ttl"
  default     = 172800
}
