resource "aws_autoscaling_policy" "scale_out" {
  name                   = "scale_out"
  scaling_adjustment     = 1
  adjustment_type        = "ChangeInCapacity"
  cooldown               = 300
  autoscaling_group_name = aws_autoscaling_group.asg.name
}

resource "aws_autoscaling_policy" "scale_in" {
  name                   = "scale_in"
  scaling_adjustment     = -1
  adjustment_type        = "ChangeInCapacity"
  cooldown               = 300
  autoscaling_group_name = aws_autoscaling_group.asg.name
}

resource "aws_cloudwatch_metric_alarm" "cpu_high" {
  alarm_name          = "${var.service_name}_cpu_high"
  metric_name         = "CPUUtilization"
  namespace           = "AWS/EC2"
  comparison_operator = "GreaterThanThreshold"
  threshold           = "95"
  evaluation_periods  = "2"
  period              = "300"
  statistic           = "Average"

  alarm_description = "${var.service_name} CPU utilization is over 95%"
  alarm_actions     = [aws_autoscaling_policy.scale_out.arn]
  dimensions = {
    AutoScalingGroupName = "video-netboot-validator_asg"
  }
}

resource "aws_cloudwatch_metric_alarm" "cpu_low" {
  alarm_name          = "${var.service_name}_cpu_low"
  metric_name         = "CPUUtilization"
  namespace           = "AWS/EC2"
  comparison_operator = "LessThanThreshold"
  threshold           = "45"
  evaluation_periods  = "2"
  period              = "300"
  statistic           = "Average"

  alarm_description = "${var.service_name} CPU utilization is under 80%"
  alarm_actions     = [aws_autoscaling_policy.scale_in.arn]
  dimensions = {
    AutoScalingGroupName = "video-netboot-validator_asg"
  }
}
