data "aws_iam_policy_document" "allow_jenkins_account" {
  statement {
    actions = ["sts:AssumeRole"]

    principals {
      type = "AWS"
      identifiers = [
        "arn:aws:iam::043714768218:role/jenkins-prod-master",
        "arn:aws:iam::043714768218:role/jenkins-prod-slave"
      ]
    }
  }
}

resource "aws_iam_role" "jenkins_iam_role" {
  name               = var.iam_role_name
  assume_role_policy = data.aws_iam_policy_document.allow_jenkins_account.json
}

resource "aws_iam_policy" "sqs_jenkins_iam_policy" {
  name  = "${var.iam_role_name}-jenkins-allow-sqs"

  policy = <<EOF
{
  "Version": "2012-10-17",
  "Statement": [
    {
      "Action": [
        "sqs:*"
      ],
      "Effect": "Allow",
      "Resource": ["*"]
    }
  ]
}
EOF
}

resource "aws_iam_role_policy_attachment" "sqs_jenkins_attach" {
  role       = aws_iam_role.jenkins_iam_role.name
  policy_arn = element(concat(aws_iam_policy.sqs_jenkins_iam_policy.*.arn, list("")), 0)
  depends_on = [
    aws_iam_policy.sqs_jenkins_iam_policy
  ]
}

resource "aws_sqs_queue" "netboot_validator_jobs" {
  name                      = "netboot-validator-jobs"
  max_message_size          = 2048
  message_retention_seconds = 600
}
