# Optional inputs
variable "env" {
  description = "Service environment - (prod|stage)"
  default     = "stage"
}

variable "region" {
  description = "The AWS region this service will be deployed"
  default     = "us-west-2"
}

variable "instance_type" {
  description = "EC2 instance type this service will be running on"
}

# Legacy mappings of environment long names
locals {
  environment_map = {
    prod  = "production"
    stage = "staging"
    dev   = "development"
  }

  environment = local.environment_map[var.env]

  common_tags = {
    Owner       = "video-coreservices@twitch.tv"
    Service     = "netboot-validator"
    Environment = var.env
    Source      = "video-coreservices/tf-io-netboot-validator"
  }
}

variable "service_name" {
  description = "Name of the service"
  default     = "netboot-validator"
}

variable "iam_role_name" {
  description = "Name of the role jenkins will assume to use sqs"
  default = "netboot_validator_sqs_role"
}
