# tf-io-package-repo
Multi-region Package Repo resources.

## Getting Started

### Prerequisites
Use https://git.xarth.tv/video-coreservices/tf-mod-bootstrap to create an S3 bucket and Dynamo DB table for storing tf state in each regional account.

### To Begin:
1. Clone this repo
2. Download the following (assuming MacOS)

  * [tfenv](https://github.com/tfutils/tfenv#automatic) --> `brew install tfenv`

3. In the root directory, run `tfenv install`
4. Copy the credentials for your AWS account in your shell (i.e: isengard temporary creds, other mechanisms)
5. Initialize your terraform environment. In the root directory, run `./deploy.sh -e <dev|prod> -r <aws_region> init`

## Requirements

### Inputs

| Name | Description | Type | Default | Required |
|------|-------------|------|---------|:-----:|
| backend\_bucket | The S3 bucket to store terraform remote state | `any` | n/a | yes |
| cidr\_vpc | The CIDR block for the VPC | `string` | n/a | yes |
| availability\_zones | Which zones to put subnets in | `list` | n/a | yes |
| cidr\_subnets | CIDR blocks for each private subnet | `list` | n/a | yes |
| region | The AWS region this service will be deployed | `string` | n/a | yes |
| env | Service environment - (prod\|dev) | `string` | n/a | yes |
| domain | The domain delegated for the region/environment | `string` | n/a | yes |
| public\_subnets | CIDR blocks for each public subnet | `list` | n/a | yes |
| vpce\_allowed\_principals | The list of trusted accounts for the VPCe. | `list` | `[]` | yes |
| nginx\_image\_version | The version of the Nginx image to use. | `string` | n/a | yes |
| aptmirror\_image\_version | The version of the Apt-mirror image to use. | `string` | n/a | yes |
| nginx\_desired\_task\_count | The number of Nginx tasks to run. | `number` | `3` | no |
| nginx\_cpu\_allocation | The number of cpu units used by the task. | `string` | `"256"` | no |
| nginx\_memory\_allocation| TThe amount of memory used by the task. | `string` | `"2048"` | no |
| asg\_size | Size of the ASG. | `number` | `3` | no |

## Planning and deploying

### ACM Bootstrapping
**IMPORTANT**: When bootstrapping, please follow this deploy order!

1. Make sure the account you're running this with has a terraform S3 and dynamoDB setup as specified in the [Prerequisites](#prerequisites) section. Copy relevant conf files in `modules/<env>/<region>`. ([see us-west-2's configuration as an example](modules/prod/us-west-2))

2. Bootstrap the ACM cert for the region `cd bootstrap_acm && ./deploy.sh -e <dev|prod> -r <aws_region> (plan|apply)`

3. Carry out the validation of the SAN cert by creating the CNAME record under the `package-repo.live-video.a2z.com` subdomain. Create here: https://tiny.amazon.com/18nymmrbx/IsenLink . This screenshot is an example from consul.
  - Note: make sure not to duplicate the subdomain when entering the record name using `san_validation_resource_record_name`.

  - Validation should take less than 30 minutes once both CNAME records are validated. The timeout for completion is 72 hours.

  ![Tutorial of step 4](imgs/img_tutorial.png)


### Root Infrastructure
1. Now let's build the infra from the **root** directory. Always plan before deploying `./deploy.sh -e <dev|prod> -r <aws_region> plan`

2. Once your plan has gotten sign off, apply `./deploy.sh -e <dev|prod> -r <aws_region> apply`

The TF run creates everything, but the ECR registries are empty. You'll need to build and upload the images:
  - Use the [package-repo-container-build](https://git.xarth.tv/video-coreservices/package-repo-container-build) pipeline to build and upload apt-mirror and nginx images to ECR


The initial download of all the mirrors will take a while since it is a large download. You can wait for the scheduled task to run, or you can start it manually using the steps below.

1. In the AWS console, go to Elastic Container Service, select cluster, and select the mrpr_cluster
2. Select the tasks tab, then run new task button
3. Select:
    - Launch type Fargate
    - Task definition mrpr_aptmirror_def
    - Version 1.4.0
    - The Package-repo VPC
    - One of the subnets associated with the VPC
    - Hit "edit" on the security groups and select the ECS and EFS security groups
4. Hit "Run"

### Latency-based record setup
If latency-based records for any region need to be created in the [package-repo-dns@amazon.com]
(https://tiny.amazon.com/9cfgteex/IsenLink) account, follow the next set of steps. Otherwise, skip to the [Root Infrastructure](#root_infrastructure) section.
1. In the [Latency_routing](../latency_routing) directory, Make sure the region's vpce hostname and zone id are accounted for in the variables.
2. Run `./deploy.sh -r <region> -e <dev/prod> (apply|plan)`


## Creating new VPCe and updating regional support

To create a VPCe and surrounding infra for a new region, create the regional conf files in the appropriate `modules` directory, run the acm_bootstrap, and run the root level terraform again.
