# Auto-scaling resources for the Nginx containers.
# Uses appautoscaling (as opposed to regular autoscaling) resources because the service is on ECS
# and uses fargate - there are no EC2 resources to manage.
# Currently min and max capacity are the same.
# We will monitor traffic and adjust scaling/attach a policy as needed

resource "aws_appautoscaling_target" "nginx_autoscaling_tg" {
  max_capacity       = var.asg_size
  min_capacity       = var.asg_size
  resource_id        = "service/${aws_ecs_cluster.mrpr_cluster.name}/${aws_ecs_service.mrpr_nginx_service.name}"
  scalable_dimension = "ecs:service:DesiredCount"
  service_namespace  = "ecs"
}
