## Table of Contents

- [Requirements](#requirements)
  - [Providers](#providers)
  - [Inputs](#inputs)
  - [Outputs](#outputs)


## Requirements

### Providers

| Name | Version |
|------|---------|
| aws | ~> 2.28 |

### Inputs

| Name | Description | Type | Default |
|------|-------------|------|---------|
| region | The AWS region this service will be deployed | `string` | `"us-west-2"` |
| backend\_bucket | The S3 bucket to store terraform remote state | `any` | n/a |
| env | Service environment - (prod\|dev) | `string` | `"dev"` |
| vpce\_allowed\_principals | The list of trusted accounts for the VPCe. | `list` | `[]` |

### Outputs

| Name | Description |
|------|-------------|
| consul\_cert\_arn | The ARN of the ACM certificate created. |
| san\_validation\_resource\_record\_name | The route 53 record name to be configured for the package-repo SAN cert. |
| san\_validation\_resource\_record\_type | The route 53 record type to be configured for the package-repo SAN cert. |
| san\_validation\_resource\_record\_value | The route 53 record value to be configured for the package-repo SAN cert. |
