terraform {
  required_version = ">= 0.12.9"

  backend "s3" {
  }
}

provider "aws" {
  region  = var.region
  version = "~> 2.28"
}

# ACM cert for the region, env this is built on.
resource "aws_acm_certificate" "mrpr_cert" {
  domain_name       = "${var.region}.${var.env}.package-repo.live-video.a2z.com"
  validation_method = "DNS"

  # Allow path to the single domain baremetal will be using
  subject_alternative_names = [
    var.main_domain
  ]

  tags = merge(
    local.common_tags,
    map(
      "Name", "${local.service_name}-acm-cert"
    )
  )

  lifecycle {
    create_before_destroy = true
  }
}

# Get the zone ID of the subdomain (managed here https://git.xarth.tv/video-coreservices/tf-io-vidcs-dns-delegations)
# but it'll be in the same account the subdomain is managed by.
data "aws_route53_zone" "mrpr_subdomain_zone" {
  name         = "${var.region}.${var.env}.package-repo.live-video.a2z.com"
  private_zone = false
}


# make the record for the subdomain validation
resource "aws_route53_record" "mrpr_cert_validate_record" {
  zone_id = data.aws_route53_zone.mrpr_subdomain_zone.zone_id
  name    = aws_acm_certificate.mrpr_cert.domain_validation_options.0.resource_record_name
  type    = aws_acm_certificate.mrpr_cert.domain_validation_options.0.resource_record_type
  ttl     = "300"
  records = [aws_acm_certificate.mrpr_cert.domain_validation_options.0.resource_record_value]
}
