# The route 53 record information needed to validate the SAN
output "san_validation_resource_record_name" {
  description = "The route 53 record name to be configured for the package-repo SAN cert."
  value       = aws_acm_certificate.mrpr_cert.domain_validation_options.1.resource_record_name
}

output "san_validation_resource_record_type" {
  description = "The route 53 record type to be configured for the package-repo SAN cert."
  value       = aws_acm_certificate.mrpr_cert.domain_validation_options.1.resource_record_type
}

output "san_validation_resource_record_value" {
  description = "The route 53 record value to be configured for the package-repo SAN cert."
  value       = aws_acm_certificate.mrpr_cert.domain_validation_options.1.resource_record_value
}

output "mrpr_cert_arn" {
  description = "The ARN of the ACM certificate created."
  value       = aws_acm_certificate.mrpr_cert.arn
}

output "mrpr_subdomain_zone_id" {
  description = "The id of the subdomain zone"
  value       = data.aws_route53_zone.mrpr_subdomain_zone.zone_id
}
