# Creates the ECR repositories for the aptmirror and nginx docker images.
# Note that the repos are created empty, and the images
# will need to be manually uploaded after resource creation

resource "aws_ecr_repository" "aptmirror_repo" {
  name                 = "docker-aptmirror"
  image_tag_mutability = "IMMUTABLE"

  tags = merge(
    local.common_tags,
    map(
      "Name", "${local.service_name}-aptmirror-repo"
    )
  )
}

resource "aws_ecr_repository" "nginx_repo" {
  name                 = "docker-nginx"
  image_tag_mutability = "IMMUTABLE"

  tags = merge(
    local.common_tags,
    map(
      "Name", "${local.service_name}-nginx-repo"
    )
  )
}

locals {
  ecr_lifecycle_policy = <<EOF
  {
      "rules": [
          {
              "rulePriority": 1,
              "description": "Keep last 400 images, of any age, out of a max of 1000",
              "selection": {
                  "tagStatus": "any",
                  "countType": "imageCountMoreThan",
                  "countNumber": 400
              },
              "action": {
                  "type": "expire"
              }
          }
      ]
  }
EOF
}

resource "aws_ecr_lifecycle_policy" "aptmirror_lifecycle_policy" {
  repository = aws_ecr_repository.aptmirror_repo.name
  policy     = local.ecr_lifecycle_policy
}

resource "aws_ecr_lifecycle_policy" "nginx_lifecycle_policy" {
  repository = aws_ecr_repository.nginx_repo.name
  policy     = local.ecr_lifecycle_policy
}
