# Creates an EFS file system and a series of mount targets for it

resource "aws_efs_file_system" "mrpr_efs" {
  throughput_mode  = "bursting"
  performance_mode = "generalPurpose"

  tags = merge(
    local.common_tags,
    map(
      "Name", "${local.service_name}-efs"
    )
  )
}

resource "aws_efs_mount_target" "mrpr_mount" {
  count           = length(module.mrpr_vpc.private_subnets)
  subnet_id       = element(module.mrpr_vpc.private_subnet_ids, count.index)
  file_system_id  = aws_efs_file_system.mrpr_efs.id
  security_groups = [aws_security_group.efs_sg.id]
}
