# Allows Jenkins to upload to ECR
locals {
  jenkins_role = "package-repo-jenkins-ecr-role"
}

module "jenkins" {
  source        = "git@git.xarth.tv:video-coreservices/tf-mod-jenkins-role?ref=v1.0.1"
  iam_role_name = local.jenkins_role
}

resource "aws_iam_role_policy_attachment" "jenkins_role_ecr_user" {
  role       = local.jenkins_role
  policy_arn = "arn:aws:iam::aws:policy/AmazonEC2ContainerRegistryPowerUser"

  depends_on = [
    module.jenkins
  ]
}
