#!/usr/bin/env bash

set -eo pipefail

export AWS_STS_REGIONAL_ENDPOINTS=regional
export AWS_SDK_LOAD_CONFIG=true

while getopts ":e:r:" opt; do
  case ${opt} in
    e )
      ENV=$OPTARG
      ;;
    r )
      REGION=$OPTARG
      ;;
    \? )
      echo "Usage: $0 [ -e prod|dev ][ -r <region> ] [init|plan|apply]" 1>&2
      exit 1
      ;;
  esac
done

requirements() {
    command -v tfenv &> /dev/null || ( echo "tfenv required but missing" && exit 1 )
}

tf_init() {
    shift

    terraform init "$@" -reconfigure -backend-config="backend.tfvars"
}

requirements

shift $((OPTIND-1))

case "$1" in
    init)
        tf_init "$@"
        ;;
    plan|apply)
        tf_init "$@"
        exec terraform "$@" \
            -var="region=${REGION}" \
            -var-file="variables.tfvars"
        ;;
    *)
        exec terraform "$@"
        ;;
esac
