terraform {
  required_version = ">= 0.14.7"

  backend "s3" {
  }
}

provider "aws" {
  region  = var.region
  version = "~> 2.28"
}

resource "aws_route53_record" "us_east_latency_record" {
  zone_id        = data.aws_route53_zone.mrpr_primary_zone.zone_id
  name           = var.domain
  type           = "A"
  set_identifier = "us-east-2"

  latency_routing_policy {
    region = "us-east-2"
  }

  alias {
    name                   = var.us_east_2_vpce
    zone_id                = var.us_east_2_zone_id
    evaluate_target_health = true
  }
}

resource "aws_route53_record" "us_west_latency_record" {
  zone_id        = data.aws_route53_zone.mrpr_primary_zone.zone_id
  name           = var.domain
  type           = "A"
  set_identifier = "us-west-2"

  latency_routing_policy {
    region = "us-west-2"
  }

  alias {
    name                   = var.us_west_2_vpce
    zone_id                = var.us_west_2_zone_id
    evaluate_target_health = true
  }
}

# Get the zone ID of the subdomain (managed here https://git.xarth.tv/video-coreservices/tf-io-vidcs-dns-delegations)
# but it'll be in the same account the subdomain is managed by.
data "aws_route53_zone" "mrpr_primary_zone" {
  name         = var.domain
  private_zone = false
}
