provider "aws" {
  region = var.region
}

data "aws_caller_identity" "current" {}

terraform {
  backend "s3" {}
  required_providers {
    aws = {
      source = "hashicorp/aws"
    }
  }
  required_version = ">= 0.14.7"
}

# Third-party module to set up scheduled ECS tasks for aptmirror to run periodically
module "ecs-fargate-scheduled-task" {
  source = "git::git+ssh://git@git.xarth.tv/video-coreservices/ecs-fargate-scheduled-task"

  name_prefix = "scheduled-aptmirror-task"

  ecs_cluster_arn                  = aws_ecs_cluster.mrpr_cluster.arn
  task_role_arn                    = aws_iam_role.execution_role.arn
  event_target_group               = "aptmirror-update"
  event_target_subnets             = module.mrpr_vpc.private_subnet_ids
  event_target_security_groups     = [aws_security_group.ecs_sg.id]
  event_rule_description           = "Run apt-mirror to update the mirrors every 24 hours"
  event_target_task_count          = "1"
  event_target_platform_version    = "1.4.0"              #This MUST be specified 1.4.0 or greater to work with fargate. "LATEST" actually defaults to 1.3.0
  event_rule_schedule_expression   = "cron(0 11 * * ? *)" #runs 11AM UTC/4AM PST daily
  event_target_task_definition_arn = aws_ecs_task_definition.mrpr_aptmirror_def.arn

  tags = merge(
    local.common_tags,
    map(
      "Name", "${local.service_name}-scheduled-task-resource"
    )
  )
}

# Twitch-created module to enable non-specific assume-role access within the Twitch Video Organization
module "video_org_principal_destination" {
  source = "git::git+ssh://git@git.xarth.tv/terraform-modules/video-organization-principal.git//destination"
}
