# Creates a VPC, private and public subnets,
# an internet gateway, a nat gateway, routing tables,
# security groups, and all the associations necesary for them


module "mrpr_vpc" {
  source             = "git@git.xarth.tv:video-coreservices/tf-mod-tiny-bubble-vpc.git?ref=v1.1.0"
  base_cidr_block    = var.cidr_vpc
  availability_zones = var.availability_zones
  service_name       = local.service_name

  tags = local.common_tags
}

resource "aws_security_group" "ecs_sg" {
  name   = "ECS-sg"
  vpc_id = module.mrpr_vpc.vpc_id

  ingress {
    from_port   = 80
    to_port     = 80
    protocol    = "tcp"
    cidr_blocks = [var.cidr_vpc]
  }

  egress {
    from_port   = 0
    to_port     = 0
    protocol    = "-1"
    cidr_blocks = ["0.0.0.0/0"]
  }

  tags = merge(
    local.common_tags,
    map(
      "Name", "${local.service_name}-ecs-sg"
    )
  )
}

resource "aws_security_group" "efs_sg" {
  name   = "EFS-sg"
  vpc_id = module.mrpr_vpc.vpc_id

  ingress {
    from_port       = 2049
    to_port         = 2049
    protocol        = "tcp"
    security_groups = [aws_security_group.ecs_sg.id]
  }

  egress {
    from_port   = 0
    to_port     = 0
    protocol    = "-1"
    cidr_blocks = ["0.0.0.0/0"]
  }

  tags = merge(
    local.common_tags,
    map(
      "Name", "${local.service_name}-sg"
    )
  )
}

resource "aws_security_group" "target_sg" {
  name   = "Target-sg"
  vpc_id = module.mrpr_vpc.vpc_id

  ingress {
    from_port   = 80
    to_port     = 80
    protocol    = "tcp"
    cidr_blocks = [var.cidr_vpc]
  }

  ingress {
    from_port   = 443
    to_port     = 443
    protocol    = "tcp"
    cidr_blocks = [var.cidr_vpc]
  }

  egress {
    from_port   = 0
    to_port     = 0
    protocol    = "-1"
    cidr_blocks = ["0.0.0.0/0"]
  }

  tags = merge(
    local.common_tags,
    map(
      "Name", "${local.service_name}-sg"
    )
  )
}
