# Alias record to the VPCe (not the VPCe service!)

data "aws_route53_zone" "subdomain_zone" {
  name         = "${var.region}.${var.env}.package-repo.live-video.a2z.com"
  private_zone = false
}

resource "aws_route53_record" "vpce_record" {
  zone_id = data.aws_route53_zone.subdomain_zone.zone_id
  name    = "${var.region}.${var.env}.package-repo.live-video.a2z.com"
  type    = "A"

  alias {
    name                   = var.vpce_name
    zone_id                = var.vpce_zone_id
    evaluate_target_health = true
  }
}
