variable "cidr_vpc" {
  description = "CIDR block for the VPC"
}

variable "availability_zones" {
  description = "Which zones to put subnets in"
  type        = list(string)
}

variable "region" {
  description = "The AWS region to create things in"
}

variable "env" {
  description = "The environment to use (dev | prod | etc.)"
}

variable "main_domain" {
  description = "The top level domain for package-repo"
  default     = "package-repo.live-video.a2z.com"
}

variable "vpce_allowed_principals" {
  description = "The list of trusted accounts for the VPCe."
  default     = []
}

variable "backend_bucket" {
  description = "The S3 bucket to store terraform remote state"
}

variable "nginx_image_version" {
  description = "The version of the docker image for Nginx to use"
}

variable "aptmirror_image_version" {
  description = "The version of the docker image for apt-mirror to use"
}

variable "nginx_desired_task_count" {
  description = "The number of Nginx tasks that should be running at any given time"
  default     = 3
}

variable "nginx_cpu_allocation" {
  description = "The number of cpu units used by the task"
  default     = "256"
}

variable "nginx_memory_allocation" {
  description = "The amount of memory in MiB used by the task"
  default     = "2048"
}

variable "asg_size" {
  description = "Size of the ASG"
  default     = 3
}

variable "vpce_name" {
  description = "The DNS Name of the VPCe for that region (Get it from Vidtools)"
}

variable "vpce_zone_id" {
  description = "The Zone ID of the VPCe for that region (Get it from Vidtools)"
}
