# Video Puppet CA Terraform

This code manages the creation and deployment of video-puppet-ca cluster. This setups the puppet instance, and associated NLB.

Endpoints:

* Prod
  * video-puppet-ca.prod.puppet.live-video.a2z.com (managed manually)
  * video-puppet-ca.us-west-2.prod.puppet.live-video.a2z.com (managed by TF)
* Stage
  * video-puppet-ca.stage.puppet.live-video.a2z.com (managed manually)
  * video-puppet-ca.us-west-2.stage.puppet.live-video.a2z.com (managed by TF)

# Usage

## Requirements
* [terrafile](https://github.com/coretech/terrafile#how-to-install)
* [tfenv](https://github.com/tfutils/tfenv#automatic)
* [aws-tools](https://git.xarth.tv/systems/aws-tools)
* AWS credentials to intended [prod/stage](https://isengard.amazon.com/console-access) accounts
  * Prod: twitch-bs-video-ops-aws@amazon.com
  * Stage: twitch-bs-video-ops-stg@amazon.com

## Deployment

To deploy terraform changes:

* `./deploy.sh -e <stage|prod> <plan|apply> ...`

## Notes

* This will create an autoscaling group of 1 Puppet CA instance.
* The puppetserver application runs within a docker container. Certificates are stored on an EFS mount mounted on `/mnt/efs`.
* Hourly backups is configured using [AWS Backup](https://us-west-2.console.aws.amazon.com/backup/home?region=us-west-2#backupvaults/details/puppet_ca_efs_backup_vault)
* Puppetserver logs are located at in [cloudwatch](https://us-west-2.console.aws.amazon.com/cloudwatch/home?region=us-west-2#logEventViewer:group=video-puppet-ca;stream=video-puppet-ca-stdout)
* The terraform code creates `video-puppet-ca.<region>.<env>.puppet.live-video.a2z.com` route53 entry.
* `video-puppet-ca.<env>.puppet.live-video.a2z.com` is managed manually to support multi-region failover in the future.
