resource "aws_cloudwatch_log_group" "lg" {
  name              = "video-puppet-ca"
  retention_in_days = "90"

  tags = local.common_tags
}

# IAM policy to allow logging in said log group
data "aws_iam_policy_document" "allow_logging" {
  statement {
    actions = ["logs:ListTagsLogGroup",
      "logs:DisassociateKmsKey",
      "logs:DescribeLogGroups",
      "logs:PutDestinationPolicy",
      "logs:DescribeLogStreams",
      "logs:DescribeSubscriptionFilters",
      "logs:DescribeMetricFilters",
      "logs:CreateLogGroup",
      "logs:PutLogEvents",
      "logs:PutMetricFilter",
      "logs:CreateExportTask",
      "logs:PutResourcePolicy",
      "logs:DescribeExportTasks",
      "logs:CreateLogStream",
      "logs:TagLogGroup",
      "logs:GetLogEvents",
      "logs:AssociateKmsKey",
      "logs:FilterLogEvents",
      "logs:PutSubscriptionFilter",
      "logs:PutRetentionPolicy",
      "logs:PutDestination",
      "logs:DescribeResourcePolicies",
      "logs:DescribeDestinations"
    ]
    resources = ["arn:aws:logs:*:*:*"]
  }
}

# Attach the above doc to a role policy
resource "aws_iam_policy" "role_policy_allow_logging" {
  name   = "video-puppet-ca-allow-logging"
  policy = data.aws_iam_policy_document.allow_logging.json
}

# Attach the above policy to the instance iam role
resource "aws_iam_policy_attachment" "logging_attachment" {
  name       = "logging attachment"
  roles      = [aws_iam_role.role.id]
  policy_arn = aws_iam_policy.role_policy_allow_logging.arn
}
