resource "aws_efs_file_system" "puppet_ca_certs" {
  encrypted = true
  tags      = merge({ Name = "puppet-ca-certs" }, local.common_tags)
}

resource "aws_security_group" "puppet_ca_servers_sg" {
  name        = "puppet-ca-sg"
  description = "puppet CA servers"
  vpc_id      = module.variables.vpc_id

  egress {
    from_port   = 0
    to_port     = 0
    protocol    = "-1"
    cidr_blocks = ["0.0.0.0/0"]
  }

  tags = merge({ Name = "puppet-ca-sg" }, local.common_tags)
}

resource "aws_security_group" "puppet_ca_efs_sg" {
  name        = "puppet-ca-efs-certs"
  description = "Access to puppet-ca-certs EFS mount"
  vpc_id      = module.variables.vpc_id

  egress {
    from_port   = 0
    to_port     = 0
    protocol    = "-1"
    cidr_blocks = ["0.0.0.0/0"]
  }

  ingress {
    from_port       = 2049
    to_port         = 2049
    protocol        = 6
    description     = "Allow efs nfs traffic"
    security_groups = [aws_security_group.puppet_ca_servers_sg.id]
  }

  tags = merge({ Name = "puppet-ca-efs-certs" }, local.common_tags)
}

resource "aws_efs_mount_target" "efs_az_a" {
  file_system_id  = aws_efs_file_system.puppet_ca_certs.id
  subnet_id       = module.variables.private_subnet_ids[0]
  security_groups = [aws_security_group.puppet_ca_efs_sg.id]
}

resource "aws_efs_mount_target" "efs_az_b" {
  file_system_id  = aws_efs_file_system.puppet_ca_certs.id
  subnet_id       = module.variables.private_subnet_ids[1]
  security_groups = [aws_security_group.puppet_ca_efs_sg.id]
}

resource "aws_efs_mount_target" "efs_az_c" {
  file_system_id  = aws_efs_file_system.puppet_ca_certs.id
  subnet_id       = module.variables.private_subnet_ids[2]
  security_groups = [aws_security_group.puppet_ca_efs_sg.id]
}

# Backups
resource "aws_backup_vault" "puppet_ca" {
  name = "puppet_ca_efs_backup_vault"
  tags = local.common_tags
}

resource "aws_backup_plan" "puppet_ca" {
  name = "puppet_ca_efs_backup_plan"

  rule {
    rule_name         = "hourly_backups"
    target_vault_name = "${aws_backup_vault.puppet_ca.name}"
    schedule          = "cron(15 * * * ? *)"

    lifecycle {
      delete_after = 35
    }
  }

  tags = local.common_tags
}

data "aws_iam_role" "backup_role" {
  name = "AWSBackupDefaultServiceRole"
}

resource "aws_backup_selection" "puppet_ca" {
  plan_id = "${aws_backup_plan.puppet_ca.id}"

  name         = "puppet_ca_efs"
  iam_role_arn = data.aws_iam_role.backup_role.arn

  resources = [
    aws_efs_file_system.puppet_ca_certs.arn,
  ]
}
