resource "aws_lb" "puppet" {
  name                       = "video-puppet-ca"
  internal                   = true
  load_balancer_type         = "network"
  subnets                    = module.variables.private_subnet_ids
  enable_deletion_protection = true

  tags = local.common_tags
}

# Puppet CA instance port
resource "aws_lb_target_group" "puppet_tg" {
  name     = "video-puppet-ca"
  port     = 8140
  protocol = "TCP"
  vpc_id   = module.variables.vpc_id

  health_check {
    protocol            = "TCP"
    interval            = 10
    healthy_threshold   = 9
    unhealthy_threshold = 9
  }

  tags = local.common_tags
}

resource "aws_lb_listener" "puppet_listener" {
  load_balancer_arn = aws_lb.puppet.arn
  port              = 8140
  protocol          = "TCP"

  default_action {
    type             = "forward"
    target_group_arn = aws_lb_target_group.puppet_tg.arn
  }
}

# SSH
resource "aws_lb_target_group" "ssh_tg" {
  name     = "video-puppet-ca-ssh"
  port     = 22
  protocol = "TCP"
  vpc_id   = module.variables.vpc_id

  health_check {
    protocol            = "TCP"
    interval            = 10
    healthy_threshold   = 3
    unhealthy_threshold = 3
  }

  tags = merge({ Name = "video-puppet-ca-tcp-22" }, local.common_tags)
}

resource "aws_lb_listener" "ssh_listener" {
  load_balancer_arn = aws_lb.puppet.arn
  port              = 22
  protocol          = "TCP"

  default_action {
    type             = "forward"
    target_group_arn = aws_lb_target_group.ssh_tg.arn
  }
}

resource "aws_route53_record" "r53_puppet" {
  zone_id = module.variables.svc_puppet_r53_zone_id
  name    = "video-puppet-ca"
  type    = "A"

  alias {
    name                   = aws_lb.puppet.dns_name
    zone_id                = aws_lb.puppet.zone_id
    evaluate_target_health = true
  }
}
