import os
import sys

import boto3

if __name__ == "__main__":
    if (len(sys.argv) != 3):
        print("bucket name and artifact name must be supplied")
        exit(1)

    bucket_name = sys.argv[1]
    artifact_name = sys.argv[2]

    codepipeline_git_metadata = 'GIT_BRANCH={} COMMIT_HASH={}'.format(
        os.getenv('BRANCH_NAME'), os.getenv('GIT_COMMIT')[0:7])
    with open(artifact_name, "rb") as f:
        boto3.client('s3').upload_fileobj(
            f,
            bucket_name,
            artifact_name,
            ExtraArgs={'Metadata': {
                'codepipeline-artifact-revision-summary': codepipeline_git_metadata}
            },
        )
