package main

import (
	"os"

	"code.justin.tv/video-coreservices/tf-io-puppet-staged-deploy/spmu/cmd/internal/config"
	"code.justin.tv/video-coreservices/tf-io-puppet-staged-deploy/spmu/cmd/internal/cwupload"
	"github.com/pkg/errors"
	log "github.com/sirupsen/logrus"
	"github.com/urfave/cli"
)

func main() {
	log.SetFormatter(&log.JSONFormatter{})
	cli.VersionFlag = &cli.BoolFlag{
		Name:  "version",
		Usage: "print the version of spmu",
	}
	app := &cli.App{
		Name:        "spmu",
		Version:     "0.0.1",
		Description: "Staged Puppet Metrics Uploader: Simple utility to log bare metal puppet staged deploy metrics.",
		UsageText:   "spmu [flags]",
		Action:      run,
		Flags: []cli.Flag{
			&cli.IntFlag{
				Name:     "code, c",
				Usage:    "Exit code from puppet.",
				Required: true,
			},
			&cli.StringFlag{
				Name:     "region, r",
				Usage:    "AWS region in deploy account to write metrics to.",
				Required: false,
			},
		},
	}
	app.Usage = app.Description
	if err := app.Run(os.Args); err != nil {
		log.Error(err)
		os.Exit(1)
	}
}

func run(c *cli.Context) error {
	// retrieve config
	cfg, err := config.SetupConfig(c.Int("code"), c.String("region"))
	if err != nil {
		return errors.Wrap(err, "failed to gather config")
	}
	// push to CW
	err = cwupload.Send(cfg)
	if err != nil {
		return errors.Wrap(err, "failed to push metrics to cloudwatch")
	}
	return nil
}
