package puppetstats_test

import (
	"testing"

	"code.justin.tv/video-coreservices/tf-io-puppet-staged-deploy/spmu/pkg/puppetstats"
	"github.com/stretchr/testify/assert"
)

var (
	testYamlFile    = "./test/test.yaml"
	testYamlFileDne = "./test/does-not-exist.yaml"

	testTimeTotal        = 35.23656525999999
	testResourcesChanged = 6
	testEventsFailure    = 1
)

func TestReadConfig(t *testing.T) {
	// Parse through test file and make sure things are populating ok.
	cfg, err := puppetstats.ReadConfig(testYamlFile)
	assert.Nil(t, err)
	assert.Equal(t, testResourcesChanged, cfg.Resources.Changed)
	assert.Equal(t, testTimeTotal, cfg.Time.Total)
	assert.Equal(t, testEventsFailure, cfg.Events.Failure)

	// Try reading a non-existent
	_, err = puppetstats.ReadConfig(testYamlFileDne)
	assert.Error(t, err)
}

func TestRetrieve(t *testing.T) {
	// Parse through test file and make sure things are populating ok.
	cfg, _ := puppetstats.ReadConfig(testYamlFile)
	total, err := puppetstats.Retrieve(cfg, "time", "total")
	assert.Nil(t, err)
	assert.Equal(t, testTimeTotal, total)
	changed, err := puppetstats.Retrieve(cfg, "Resources", "changed")
	assert.Nil(t, err)
	// This function should standarize return values to floats to ease metrics things
	assert.Equal(t, float64(testResourcesChanged), changed)
	// Test failure cases.
	_, err = puppetstats.Retrieve(cfg, "DoesNotExist", "total")
	assert.Error(t, err)

	_, err = puppetstats.Retrieve(cfg, "Time", "DoesNotExist")
	assert.Error(t, err)
}
