# Machine Classification Key (MCK)

This package provides a way to obtain the Machine Classification Key on a host
(MCK). This concept has been discussed in the [Bare Metal Node
Classification](https://docs.google.com/document/d/1BJrlADiDusQFtEyDJ5d12ta0lUgyDA_97SYa-be35_U/edit#)
google doc.

# Usage

The current implementation fetches information from facter. It may run
indefinitely if facter is slow, but you can pass a context with a timeout. It
may return fields with empty strings if that's what facter returns. Since
facter requires root, you must run the process as root to obtain information.

See the `examples/` directory for usage examples.

The facter implementation will be replaced in a future version.

# Smoke test

Sometimes you don't need this package as a library, but rather, as a quick
debugging executable. This repo provides just that.

```sh-session
$ env GOOS=linux GOARCH=amd64 go build examples/facter/main.go
$ scp main video-pr-staging-826494.sjc02.justin.tv:
main                                                 100% 2506KB   2.5MB/s   00:01    
$ ssh video-pr-staging-826494.sjc02.justin.tv './main' # running as a non-root user won't work
unable to obtain any environment information from facter
$ ssh video-pr-staging-826494.sjc02.justin.tv 'sudo ./main; rm main'
&mck.MCK{MachineClass:"video-pr-staging", Environment:"staging", Pop:"sjc02"}
```

