# Common

Commonly shared variables between deploy and control account terraform configuration.

<!-- BEGINNING OF PRE-COMMIT-TERRAFORM DOCS HOOK -->
## Requirements

No requirements.

## Providers

No providers.

## Modules

| Name | Source | Version |
|------|--------|---------|
| <a name="module_datacenters"></a> [datacenters](#module\_datacenters) | git@git.xarth.tv:video-coreservices/tf-mod-datacenters-metadata.git | n/a |
| <a name="module_default_behavior"></a> [default\_behavior](#module\_default\_behavior) | git::ssh://git@git.xarth.tv/video-tools/deployment-terraform.git//modules/common/default_behavior | v1.0.7 |

## Resources

No resources.

## Inputs

No inputs.

## Outputs

| Name | Description |
|------|-------------|
| <a name="output_config"></a> [config](#output\_config) | Shared configuration to be used by the control and deploy modules. Refer to "Deploy Account Map Structure" below for more details. |
<!-- END OF PRE-COMMIT-TERRAFORM DOCS HOOK -->

## Deploy Account Map Structure

- `control_account_id`: The ID of the control account for staged puppet.
- `artifact_name`: The name of the artifact that is published to S3 per pipeline. The name is the same between all staged puppet pipelines, but uploaded per pipeline bucket.
- `emergency_pipeline_artifact_name`: The name of the emergency artifact that is published to S3 per pipeline. The name is the same between all staged puppet pipelines, but uploaded per pipeline bucket.
- `deploy_account_map`: A map of deploy account aliases to an object of shared metadata of those accounts, including pipeline and deploy metadata instructions. The structure of a deploy account's value is as follows:
```hcl
type = object({
  control_account_id = string,
  deploy_account_map = object({
    account_id       = string,
    application_name = string,
    machine_classes  = list(string),
    pipeline_name    = string,
    pipeline_stages = list(object({
      machine_classes                   = list(string),
      stage_description                 = string,
      pops                              = string,
      environment                       = string,
      approval_config                   = string,
      codedeploy_account_id             = string,
      minimum_healthy_hosts_percent     = number,
      max_concurrent_deployment_actions = number,
      deployment_actions                = map,
      codedeploy_deployment_config_name = string,
    })),
  }),
})
```
