# Control Account Terraform

Contains the terraform configuration to set up and update the staged deploy control account IAC.

Currently, the control account for this staged puppet POC is 

| Account Alias                     | Account Num  | Link in Isengard                                                |
|-----------------------------------|--------------|-----------------------------------------------------------------|
| twitch-vidcs-video-puppet-control | 458835690105 | https://isengard.amazon.com/manage-accounts/458835690105/manage |

<!-- BEGINNING OF PRE-COMMIT-TERRAFORM DOCS HOOK -->
## Requirements

| Name | Version |
|------|---------|
| <a name="requirement_terraform"></a> [terraform](#requirement\_terraform) | = 0.15.4 |
| <a name="requirement_aws"></a> [aws](#requirement\_aws) | ~> 3.44.0 |

## Providers

| Name | Version |
|------|---------|
| <a name="provider_aws"></a> [aws](#provider\_aws) | 3.44.0 |

## Modules

| Name | Source | Version |
|------|--------|---------|
| <a name="module_common"></a> [common](#module\_common) | ../common | n/a |
| <a name="module_control_pipelines"></a> [control\_pipelines](#module\_control\_pipelines) | git::ssh://git@git.xarth.tv/video-tools/deployment-terraform.git//modules/unified/pipeline | v1.0.7 |
| <a name="module_kop"></a> [kop](#module\_kop) | git::ssh://git@git.xarth.tv/video/kop.git//terraform/publish | 4ec30233a1a527122af20196af25faa79f23a7f3 |
| <a name="module_pipeline_service_roles"></a> [pipeline\_service\_roles](#module\_pipeline\_service\_roles) | git::ssh://git@git.xarth.tv/video-tools/deployment-terraform.git//modules/common/pipeline-service-role | v1.0.7 |

## Resources

| Name | Type |
|------|------|
| [aws_iam_role.jenkins_admin_access](https://registry.terraform.io/providers/hashicorp/aws/latest/docs/resources/iam_role) | resource |
| [aws_iam_role_policy_attachment.jenkins_admin_access](https://registry.terraform.io/providers/hashicorp/aws/latest/docs/resources/iam_role_policy_attachment) | resource |
| [aws_caller_identity.current](https://registry.terraform.io/providers/hashicorp/aws/latest/docs/data-sources/caller_identity) | data source |
| [aws_iam_policy_document.jenkins_admin_access](https://registry.terraform.io/providers/hashicorp/aws/latest/docs/data-sources/iam_policy_document) | data source |

## Inputs

No inputs.

## Outputs

No outputs.
<!-- END OF PRE-COMMIT-TERRAFORM DOCS HOOK -->

## Deploy/Update

- Get (isengard creds)[https://isengard.amazon.com/manage-accounts] for your account. isengardcli works too:
  ```
  isengardcli assume twitch-vidcs+video-puppet-control --role Admin
  ```

- Plan
  ```
  ./deploy.sh -a twitch-vidcs-video-puppet-control plan
  ```

- Apply
  ```
  ./deploy.sh -a twitch-vidcs-video-puppet-control apply
  ```

## Troubleshooting

- Error: 
  ```
  Successfully configured the backend "s3"! Terraform will automatically
  use this backend unless the backend configuration changes.
  Error refreshing state: AccessDenied: Access Denied
  status code: 403,
  ```
- Cause: You've loaded the wrong account creds or you haven't created the tf state bucket in your account yet.

- You see: a lot of changes that look like pop reshuffling:
  ```
          ~ action {
              ~ configuration    = {
                  ~ "UserParameters"      = jsonencode(
                      ~ {
                          ~ codedeploy_deployment_group   = "production-cmh01-origin-rollout-cmh01-1" -> "production-iad06-origin-rollout-iad06-1"
                          ~ izzit_pop                     = "cmh01" -> "iad06"
                            # (8 unchanged elements hidden)
                        }
                    )
                    # (4 unchanged elements hidden)
                }
              ~ name             = "emergency-production-cmh01-origin-rollout-cmh01-1" -> "emergency-production-iad06-origin-rollout-iad06-1"
                # (7 unchanged attributes hidden)
            }
  ```
- Cause: probably some pop was decommissioned in the [datacenter metadata](https://git.xarth.tv/video-coreservices/tf-mod-datacenters-metadata) so the ordering changed.
