// Configure the codepipeline for the staged puppet application.

# prod pipeline resources

module "pipeline_service_roles" {
  for_each         = local.account_cfg
  source           = "git::ssh://git@git.xarth.tv/video-tools/deployment-terraform.git//modules/common/pipeline-service-role?ref=v1.0.7"
  application_name = each.value["application_name"]
}

// Create pipelines per account
module "control_pipelines" {
  for_each         = local.account_cfg
  source           = "git::ssh://git@git.xarth.tv/video-tools/deployment-terraform.git//modules/unified/pipeline?ref=v1.0.7"
  application_name = each.value["application_name"]
  artifact_name    = module.common.config["artifact_name"]
  pipeline_name    = each.value["application_name"]
  pipeline_stages  = each.value["pipeline_stages"]
  // pipeline service role names are deterministically created by the same metadata config.
  pipeline_service_role_arn = "arn:aws:iam::${module.common.config["control_account_id"]}:role/${each.value["application_name"]}-codepipeline-service-role"
  // milliner role names are deterministically created by the same metadata config.
  milliner_application_role_arns = [for machine_class in each.value["machine_classes"] :
    "arn:aws:iam::${each.value["account_id"]}:role/${machine_class}-milliner-service-role"
  ]

  emergency_pipeline_artifact_name = module.common.config["emergency_pipeline_artifact_name"]
}
