resource "aws_iam_role" "jenkins_admin_access" {
  name = "jenkins-admin-access"

  assume_role_policy = data.aws_iam_policy_document.jenkins_admin_access.json
}

// Policy Document for allowing the CodePipeline service to assume the role.
data "aws_iam_policy_document" "jenkins_admin_access" {
  statement {
    actions = ["sts:AssumeRole"]
    principals {
      type = "AWS"
      identifiers = [
        "arn:aws:iam::043714768218:role/jenkins-prod-master",
        "arn:aws:iam::043714768218:role/jenkins-prod-slave",
      ]
    }
  }
}

resource "aws_iam_role_policy_attachment" "jenkins_admin_access" {
  role       = aws_iam_role.jenkins_admin_access.name
  policy_arn = "arn:aws:iam::aws:policy/AdministratorAccess"
}
