terraform {
  required_version = "= 0.15.4"
  required_providers {
    aws = {
      version = "~> 3.44.0"
    }
  }
  backend "s3" {
    key            = "terraform.tfstate"
    region         = "us-west-2"
    dynamodb_table = "terraform_locks"
  }
}

provider "aws" {
  region = "us-west-2"
}

module "common" {
  source = "../common"
}

data "aws_caller_identity" "current" {}

locals {
  account_cfg = module.common.config["deploy_account_map"]

  // Validation that the caller is from the correct account.
  intended_acc_id      = module.common.config["control_account_id"]
  validate_account_cnd = data.aws_caller_identity.current.account_id == local.intended_acc_id
  validate_account_msg = <<EOT
The caller account is ${data.aws_caller_identity.current.account_id} which does not match
the control account's id of the control account (${local.intended_acc_id})"
EOT
}

// Sends notifications to slack on CodePipeline progress
module "kop" {
  source = "git::ssh://git@git.xarth.tv/video/kop.git//terraform/publish?ref=4ec30233a1a527122af20196af25faa79f23a7f3"
}
