# Deploy Account Terraform

Contains the terraform configuration to set up and update the staged deploy deploy accounts IAC.

Importantly, includes the new IAC management of milliner roles of vidcs owned machine classes, superceding the [party account repo](https://git.xarth.tv/video-coreservices/tf-io-video-ops-party-account/blob/master/milliner.tf).

Currently, the control account for this staged puppet POC is 

| Account Alias                   | Account Num  | Link in Isengard                                                |
|---------------------------------|--------------|-----------------------------------------------------------------|
| twitch-vidcs-consul-master-prod | 625394079058 | https://isengard.amazon.com/manage-accounts/625394079058/manage |
| twitch-vidcs-dns-auth-prod      | 310631158791 | https://isengard.amazon.com/manage-accounts/310631158791/manage |
| twitch-vidcs-dns-resolver-prod  | 469262527252 | https://isengard.amazon.com/manage-accounts/469262527252/manage |
| twitch-vidcs-pop-masters-prod   | 825658541764 | https://isengard.amazon.com/manage-accounts/825658541764/manage |
| twitch-vidcs-squid-proxy-prod   | 719152506984 | https://isengard.amazon.com/manage-accounts/719152506984/manage |

<!-- BEGINNING OF PRE-COMMIT-TERRAFORM DOCS HOOK -->
## Requirements

| Name | Version |
|------|---------|
| <a name="requirement_terraform"></a> [terraform](#requirement\_terraform) | = 0.15.4 |
| <a name="requirement_aws"></a> [aws](#requirement\_aws) | ~> 3.44.0 |
| <a name="requirement_null"></a> [null](#requirement\_null) | ~> 2.1 |

## Providers

| Name | Version |
|------|---------|
| <a name="provider_aws"></a> [aws](#provider\_aws) | 1.0.3 |
| <a name="provider_null"></a> [null](#provider\_null) | 2.1.2 |

## Modules

| Name | Source | Version |
|------|--------|---------|
| <a name="module_codedeploy_policy"></a> [codedeploy\_policy](#module\_codedeploy\_policy) | git::ssh://git@git.xarth.tv/terraform-modules/codedeploy-registration-policy.git | n/a |
| <a name="module_codedeploy_prod_us_west_2"></a> [codedeploy\_prod\_us\_west\_2](#module\_codedeploy\_prod\_us\_west\_2) | git::ssh://git@git.xarth.tv/video-tools/deployment-terraform.git//modules/unified/codedeploy | terraform13 |
| <a name="module_common"></a> [common](#module\_common) | ../common | n/a |
| <a name="module_control_account_tf_role"></a> [control\_account\_tf\_role](#module\_control\_account\_tf\_role) | git::ssh://git@git.xarth.tv/video-tools/deployment-terraform.git//modules/common/control_account_tf_role | v1.0.7 |
| <a name="module_milliner_principal"></a> [milliner\_principal](#module\_milliner\_principal) | git::ssh://git@git.xarth.tv/terraform-modules/milliner-principal-policy.git | n/a |
| <a name="module_pipeline_approval_metrics_role"></a> [pipeline\_approval\_metrics\_role](#module\_pipeline\_approval\_metrics\_role) | git::ssh://git@git.xarth.tv/video-tools/deployment-terraform.git//modules/common/pipeline_approval_metrics_role | v1.0.7 |
| <a name="module_vidcs_source"></a> [vidcs\_source](#module\_vidcs\_source) | git::git+ssh://git@git.xarth.tv/terraform-modules/video-organization-principal.git//source | n/a |

## Resources

| Name | Type |
|------|------|
| [aws_iam_policy_attachment.cloudwatch](https://registry.terraform.io/providers/hashicorp/aws/latest/docs/resources/iam_policy_attachment) | resource |
| [aws_iam_policy_attachment.codedeploy](https://registry.terraform.io/providers/hashicorp/aws/latest/docs/resources/iam_policy_attachment) | resource |
| [aws_iam_role.staged_deploy_role](https://registry.terraform.io/providers/hashicorp/aws/latest/docs/resources/iam_role) | resource |
| [null_resource.validate_account](https://registry.terraform.io/providers/hashicorp/null/latest/docs/resources/resource) | resource |
| [aws_caller_identity.current](https://registry.terraform.io/providers/hashicorp/aws/latest/docs/data-sources/caller_identity) | data source |
| [aws_iam_account_alias.current](https://registry.terraform.io/providers/hashicorp/aws/latest/docs/data-sources/iam_account_alias) | data source |

## Inputs

| Name | Description | Type | Default | Required |
|------|-------------|------|---------|:--------:|
| <a name="input_account_alias"></a> [account\_alias](#input\_account\_alias) | The intended AWS account alias of the caller. | `string` | n/a | yes |
| <a name="input_additional_control_account_ids"></a> [additional\_control\_account\_ids](#input\_additional\_control\_account\_ids) | Any additional AWS control account IDs. | `list(number)` | `[]` | no |

## Outputs

No outputs.
<!-- END OF PRE-COMMIT-TERRAFORM DOCS HOOK -->

## Deploy/Update

- Get (isengard creds)[https://isengard.amazon.com/manage-accounts] for your account. isengardcli works too:
  ```
  isengardcli assume twitch-vidcs+video-puppet-control --role Admin
  ```

- Plan
  ```
  ./deploy.sh -a <account-name> plan
  ```

- Apply
  ```
  ./deploy.sh -a <account-name> apply
  ```

## Troubleshooting

- Error: 
  ```
  Successfully configured the backend "s3"! Terraform will automatically
  use this backend unless the backend configuration changes.
  Error refreshing state: AccessDenied: Access Denied
  status code: 403,
  ```
- Cause: You've loaded the wrong account creds or you haven't created the tf state bucket in your account yet.
