# grant the control account access to run terraform in this account
module "control_account_tf_role" {
  source                         = "git::ssh://git@git.xarth.tv/video-tools/deployment-terraform.git//modules/common/control_account_tf_role?ref=v1.0.7"
  control_account_id             = module.common.config["control_account_id"]
  additional_control_account_ids = var.additional_control_account_ids
}

# instantiate the metrics approval role to allow automatic approvals to read alarm state
# in this account
# grant the control account access to run terraform in this account
module "pipeline_approval_metrics_role" {
  source             = "git::ssh://git@git.xarth.tv/video-tools/deployment-terraform.git//modules/common/pipeline_approval_metrics_role?ref=v1.0.7"
  control_account_id = module.common.config["control_account_id"]
}
