terraform {
  required_version = "= 0.15.4"
  required_providers {
    aws = {
      version = "~> 3.44.0"
    }
  }
  backend "s3" {
    region         = "us-west-2"
    key            = "terraform.tfstate"
    dynamodb_table = "terraform_locks"
  }
}

provider "aws" {
  region = "us-west-2"
}

module "common" {
  source = "../common"
}

data "aws_iam_account_alias" "current" {}
data "aws_caller_identity" "current" {}

// Validate caller account matches intended backend deploy account.
locals {
  // Selection of which metadata to use determined by input account
  account_cfg = module.common.config["deploy_account_map"][var.account_alias]

  // Validation that the caller is from the correct account.
  intended_acc_id      = local.account_cfg["account_id"]
  validate_account_cnd = data.aws_caller_identity.current.account_id == local.intended_acc_id
  validate_account_msg = <<EOT
The caller account is ${data.aws_caller_identity.current.account_id} which does not match
the account id of ${var.account_alias}'s, (${local.intended_acc_id})"
EOT
}

provider "null" {
  version = "~> 2.1"
}

resource "null_resource" "validate_account" {
  count = local.validate_account_cnd ? 0 : local.validate_account_msg
}
