locals {
  machine_classes = toset(module.common.config["deploy_account_map"][data.aws_iam_account_alias.current.account_alias]["machine_classes"])
}
// (1 of 3) instantiate the milliner-principal module
module "milliner_principal" {
  source = "git::ssh://git@git.xarth.tv/terraform-modules/milliner-principal-policy.git"
}

// (2 of 3) include the milliner-principal policy in your iam-role's trust-policy
resource "aws_iam_role" "staged_deploy_role" {
  for_each           = local.machine_classes
  name               = "${each.value}-milliner-service-role"
  description        = "IAM role assumed by Staged Deploy hosts through Milliner"
  assume_role_policy = module.milliner_principal.policy_document
}

// (3 of 3) instantiate the video-org source module and pass your iam-role to it
module "vidcs_source" {
  for_each      = local.machine_classes
  source        = "git::git+ssh://git@git.xarth.tv/terraform-modules/video-organization-principal.git//source"
  iam_role_name = "${each.value}-milliner-service-role"
}


// Expose IAM policy document to allow CodeDeploy-related actions
module "codedeploy_policy" {
  source = "git::ssh://git@git.xarth.tv/terraform-modules/codedeploy-registration-policy.git"
}

locals {
  milliner_role_names = toset([
    for role in aws_iam_role.staged_deploy_role : role.name
  ])
}

resource "aws_iam_policy_attachment" "codedeploy" {
  name       = "codedeploy-attachment"
  roles      = local.milliner_role_names
  policy_arn = module.codedeploy_policy.arn
}

// Add cloudwatch policy 
resource "aws_iam_policy_attachment" "cloudwatch" {
  name       = "cloudwatch-permissions"
  roles      = local.milliner_role_names
  policy_arn = "arn:aws:iam::aws:policy/CloudWatchAgentServerPolicy"
}
