# Video Puppet Masters Terraform

This code manages the creation and deployment of video-puppet-master cluster. This setups the puppet instances, and associated NLB.

* Prod
  * video-puppet.prod.puppet.live-video.a2z.com
  * video-puppet.us-west-2.prod.puppet.live-video.a2z.com
* Stage
  * video-puppet.stage.puppet.live-video.a2z.com
  * video-puppet.us-west-2.stage.puppet.live-video.a2z.com

# Usage

## Requirements
* [terrafile](https://github.com/coretech/terrafile#how-to-install)
* [tfenv](https://github.com/tfutils/tfenv#automatic)
* AWS credentials to intended [prod/stage](https://isengard.amazon.com/console-access) accounts
  * Prod: twitch-bs-video-ops-aws@amazon.com
  * Stage: twitch-bs-video-ops-stg@amazon.com

## Deployment

To deploy terraform changes:

* `./deploy.sh -e <stage|prod> <plan|apply> ...`

## Runbooks

Refer [Video Puppet Master Runbook](https://wiki.twitch.com/display/VID/Video+Puppet+Master+Runbook).

## Notes

* The terraform code creates `video-puppet.<region>.<env>.puppet.live-video.a2z.com` route53 entry.
* `video-puppet.<env>.puppet.live-video.a2z.com` is managed manually to support multi-region deployments in the future.
* AWS NLB is very rudimentary in TCP puppet healthchecking. As long as port 8140 (nginx) is up and running, the ec2 instance will be considered healthy from the perspective of the NLB.
* Github webhook is served via port 8090. Webhook registration is done automatically on puppet setup.

## Development

On OS X, the following requirements are available via [homebrew](https://brew.sh/).

* Setup [`pre-commit`](https://pre-commit.com/#install).
* Make sure the following dependencies are installed:
  * [`pre-commit terraform`](https://github.com/antonbabenko/pre-commit-terraform#step-1)
  * [`terraform-docs`](https://github.com/segmentio/terraform-docs#installation)

Run `pre-commit install` to install `pre-commit` hook.

<!-- BEGINNING OF PRE-COMMIT-TERRAFORM DOCS HOOK -->
## Requirements

| Name | Version |
|------|---------|
| <a name="requirement_terraform"></a> [terraform](#requirement\_terraform) | >= 0.12 |
| <a name="requirement_aws"></a> [aws](#requirement\_aws) | >= 3.24.0 |
| <a name="requirement_null"></a> [null](#requirement\_null) | ~> 2.1 |
| <a name="requirement_template"></a> [template](#requirement\_template) | ~> 2.1 |

## Providers

| Name | Version |
|------|---------|
| <a name="provider_aws"></a> [aws](#provider\_aws) | >= 3.24.0 |

## Modules

| Name | Source | Version |
|------|--------|---------|
| <a name="module_puppet-env-backend"></a> [puppet-env-backend](#module\_puppet-env-backend) | git@git.xarth.tv:video-coreservices/tf-mod-puppet-env-backend.git | v0.0.3 |
| <a name="module_puppet_master_asg"></a> [puppet\_master\_asg](#module\_puppet\_master\_asg) | ./vendor/modules/asg | n/a |
| <a name="module_puppet_sns_topic"></a> [puppet\_sns\_topic](#module\_puppet\_sns\_topic) | ./vendor/modules/sns-alarm | n/a |
| <a name="module_variables"></a> [variables](#module\_variables) | ./vendor/modules/twitch-video-ops-defaults/current | n/a |

## Resources

| Name | Type |
|------|------|
| [aws_cloudwatch_composite_alarm.example](https://registry.terraform.io/providers/hashicorp/aws/latest/docs/resources/cloudwatch_composite_alarm) | resource |
| [aws_cloudwatch_metric_alarm.cluster_cpu_anomaly](https://registry.terraform.io/providers/hashicorp/aws/latest/docs/resources/cloudwatch_metric_alarm) | resource |
| [aws_cloudwatch_metric_alarm.cluster_cpu_threshold](https://registry.terraform.io/providers/hashicorp/aws/latest/docs/resources/cloudwatch_metric_alarm) | resource |
| [aws_cloudwatch_metric_alarm.unhealthy_hosts](https://registry.terraform.io/providers/hashicorp/aws/latest/docs/resources/cloudwatch_metric_alarm) | resource |
| [aws_iam_policy.cloudwatch_access](https://registry.terraform.io/providers/hashicorp/aws/latest/docs/resources/iam_policy) | resource |
| [aws_iam_policy.sandstorm_access](https://registry.terraform.io/providers/hashicorp/aws/latest/docs/resources/iam_policy) | resource |
| [aws_iam_role_policy_attachment.cloudwatch_access_attachment_asg](https://registry.terraform.io/providers/hashicorp/aws/latest/docs/resources/iam_role_policy_attachment) | resource |
| [aws_iam_role_policy_attachment.sandstorm_access_attachment_asg](https://registry.terraform.io/providers/hashicorp/aws/latest/docs/resources/iam_role_policy_attachment) | resource |
| [aws_lb.puppet](https://registry.terraform.io/providers/hashicorp/aws/latest/docs/resources/lb) | resource |
| [aws_lb_listener.puppet_listener](https://registry.terraform.io/providers/hashicorp/aws/latest/docs/resources/lb_listener) | resource |
| [aws_lb_target_group.puppet_tg](https://registry.terraform.io/providers/hashicorp/aws/latest/docs/resources/lb_target_group) | resource |
| [aws_route53_record.r53_puppet](https://registry.terraform.io/providers/hashicorp/aws/latest/docs/resources/route53_record) | resource |
| [aws_iam_policy_document.cloudwatch_access](https://registry.terraform.io/providers/hashicorp/aws/latest/docs/data-sources/iam_policy_document) | data source |
| [aws_iam_policy_document.sandstorm_access](https://registry.terraform.io/providers/hashicorp/aws/latest/docs/data-sources/iam_policy_document) | data source |

## Inputs

| Name | Description | Type | Default | Required |
|------|-------------|------|---------|:--------:|
| <a name="input_ebs_volume_size"></a> [ebs\_volume\_size](#input\_ebs\_volume\_size) | EBS volume size (GB) to store puppet code | `number` | `500` | no |
| <a name="input_enable_monitoring"></a> [enable\_monitoring](#input\_enable\_monitoring) | boolean to enable monitoring | `bool` | `true` | no |
| <a name="input_env"></a> [env](#input\_env) | Service environment. Either stage, prod | `string` | `"stage"` | no |
| <a name="input_instance_count"></a> [instance\_count](#input\_instance\_count) | Number of instances to run | `number` | `1` | no |
| <a name="input_instance_type"></a> [instance\_type](#input\_instance\_type) | EC2 instance type this service will be running on | `string` | `"m5.large"` | no |
| <a name="input_region"></a> [region](#input\_region) | The AWS region this service will be deployed | `string` | `"us-west-2"` | no |
| <a name="input_service"></a> [service](#input\_service) | Service name. Defaults to video-puppet-master | `string` | `"video-puppet-master"` | no |

## Outputs

No outputs.
<!-- END OF PRE-COMMIT-TERRAFORM DOCS HOOK -->
