# TODO: Migrate this to a NLB module
# Reminder: AWS NLB only does barebones TCP healthcheck (i.e. establishing TCP connection)

resource "aws_lb" "puppet" {
  name                       = var.service
  internal                   = true
  load_balancer_type         = "network"
  subnets                    = module.variables.private_subnet_ids
  enable_deletion_protection = true

  tags = {
    Owner       = "video-coreservices@twitch.tv"
    Service     = "puppet"
    Environment = var.env
  }
}

resource "aws_lb_target_group" "puppet_tg" {
  name     = var.service
  port     = 8140
  protocol = "TCP"
  vpc_id   = module.variables.vpc_id

  health_check {
    protocol            = "TCP"
    interval            = 10
    healthy_threshold   = 2
    unhealthy_threshold = 2
  }

  tags = {
    Name        = "${var.service}-tcp-8140"
    Environment = var.env
    Owner       = "video-coreservices@twitch.tv"
    Service     = "puppet"
  }
}

resource "aws_lb_listener" "puppet_listener" {
  load_balancer_arn = aws_lb.puppet.arn
  port              = 8140
  protocol          = "TCP"

  default_action {
    type             = "forward"
    target_group_arn = aws_lb_target_group.puppet_tg.arn
  }
}

resource "aws_route53_record" "r53_puppet" {
  zone_id = module.variables.svc_puppet_r53_zone_id
  name    = "video-puppet"
  type    = "A"

  alias {
    name                   = aws_lb.puppet.dns_name
    zone_id                = aws_lb.puppet.zone_id
    evaluate_target_health = true
  }
}
