# Optional inputs
variable "service" {
  description = "Service name. Defaults to video-puppet-master"
  default     = "video-puppet-master"
}

variable "env" {
  description = "Service environment. Either stage, prod"
  default     = "stage"
}

variable "region" {
  description = "The AWS region this service will be deployed"
  default     = "us-west-2"
}

variable "instance_type" {
  description = "EC2 instance type this service will be running on"
  default     = "m5.large"
}

variable "instance_count" {
  description = "Number of instances to run"
  default     = 1
}

variable "ebs_volume_size" {
  description = "EBS volume size (GB) to store puppet code"
  default     = 500
}

variable "enable_monitoring" {
  description = "boolean to enable monitoring"
  default     = true
}

# Legacy mappings of environment long names
locals {
  environment_map = {
    prod  = "production"
    stage = "staging"
    dev   = "development"
  }

  environment = local.environment_map[var.env]
}
