# Video CoreServices StatsD/Graphite Metrics Deployment

This deploys a voncount + self hosted graphite infrastructure.

<!-- START doctoc generated TOC please keep comment here to allow auto update -->
<!-- DON'T EDIT THIS SECTION, INSTEAD RE-RUN doctoc TO UPDATE -->


- [Requirements](#requirements)
- [Deployment](#deployment)
  - [Usage](#usage)
  - [Building new containers](#building-new-containers)
  - [Deploying new containers](#deploying-new-containers)
- [Terraform inputs](#terraform-inputs)
  - [Requirements](#requirements-1)
  - [Providers](#providers)
  - [Modules](#modules)
  - [Resources](#resources)
  - [Inputs](#inputs)
  - [Outputs](#outputs)
- [Development](#development)
  - [Known Issues](#known-issues)

<!-- END doctoc generated TOC please keep comment here to allow auto update -->

## Requirements

* [tfenv](https://github.com/tfutils/tfenv#automatic)
* AWS credentials to assume `Admin` roles of
  * Prod - [twitch-video-coreservices+metrics-prod-us-west-2@amazon.com (355334781110)](https://isengard.amazon.com/console-access) account.

## Deployment

The `deploy.sh` script takes an argument for `env` and `region`. `env` can be one of `dev|staging|prod` and `region` will always be `us-west-2` as this is only deployed in the `us-west-2` region.

Environment specific variables is found under `conf/<env>/<region>/variables.tfvars`. E.g. `[conf/prod/us-west-2/variables.tfvars](./conf/prod/us-west-2/variables.tfvars)` is for `us-west-2` `prod`.

### Usage

```bash
./deploy.sh -e <env> -r <region> apply
```

### Building new containers

Check the respective container repos:

* [statsd-proxy](https://git.xarth.tv/video-coreservices/go-statsd-proxy)
* [voncount aka statsite](https://git.xarth.tv/video-coreservices/voncount)
* [carbon-c-relay](https://git.xarth.tv/video-coreservices/carbon-c-relay-container-build)
* [go-carbon](https://git.xarth.tv/video-coreservices/go-carbon-container-build)
* [graphite-web](https://git.xarth.tv/video-coreservices/graphite-web-container-build)

Upon changes, Jenkins will build and upload to the respective ECR which hosts the required containers.

### Deploying new containers

Update the container specific tags, e.g. `statsd_proxy_image_tag`, `statsite_image_tag`, etc, then rerun `./deploy.sh` steps above. This will force new ECS task replacement, and ECS will automatically provision new tasks, and tear down old tasks.


## Terraform inputs

<!-- BEGINNING OF PRE-COMMIT-TERRAFORM DOCS HOOK -->
### Requirements

| Name | Version |
|------|---------|
| <a name="requirement_terraform"></a> [terraform](#requirement\_terraform) | =0.14.7 |
| <a name="requirement_aws"></a> [aws](#requirement\_aws) | ~> 3.37.0 |

### Providers

No providers.

### Modules

| Name | Source | Version |
|------|--------|---------|
| <a name="module_statsd_graphite"></a> [statsd\_graphite](#module\_statsd\_graphite) | git@git.xarth.tv:video-coreservices/tf-mod-statsd-graphite?ref=v1.1.1 |  |

### Resources

No resources.

### Inputs

| Name | Description | Type | Default | Required |
|------|-------------|------|---------|:--------:|
| <a name="input_carbon_c_relay_cluster_size"></a> [carbon\_c\_relay\_cluster\_size](#input\_carbon\_c\_relay\_cluster\_size) | The desired cluster size for carbon-c-relay | `number` | `2` | no |
| <a name="input_carbon_c_relay_image_tag"></a> [carbon\_c\_relay\_image\_tag](#input\_carbon\_c\_relay\_image\_tag) | The image hash/tag that will be used to run carbon-c-relay | `string` | `"v3.7.2"` | no |
| <a name="input_env"></a> [env](#input\_env) | The stack environment. One of dev, staging, or prod | `string` | `null` | no |
| <a name="input_go_carbon_cluster_size"></a> [go\_carbon\_cluster\_size](#input\_go\_carbon\_cluster\_size) | ATTENTION: this should be a fixed size, and not be changed after the cluster has been provisioned. Size cluster accordingly.<br>  The desired cluster size for each go-carbon cluster replica. I.e. The total number of instances deployed will double this number provided." | `number` | n/a | yes |
| <a name="input_go_carbon_image_tag"></a> [go\_carbon\_image\_tag](#input\_go\_carbon\_image\_tag) | The image hash/tag that will be used to run go\_carbon | `string` | `"v0.15.6"` | no |
| <a name="input_graphite_web_cluster_size"></a> [graphite\_web\_cluster\_size](#input\_graphite\_web\_cluster\_size) | The desired cluster size for statsd-proxy | `number` | `2` | no |
| <a name="input_graphite_web_image_tag"></a> [graphite\_web\_image\_tag](#input\_graphite\_web\_image\_tag) | The image hash/tag that will be used to run graphite-web | `string` | `"1ca8e602c15ba9ed7737976d01c9d1ba10eafa40"` | no |
| <a name="input_pagerduty_url"></a> [pagerduty\_url](#input\_pagerduty\_url) | The pagerduty cloudwatch integration URL used to alert teams of issues | `string` | n/a | yes |
| <a name="input_region"></a> [region](#input\_region) | The AWS region to deploy this stack to | `string` | `"us-west-2"` | no |
| <a name="input_security_groups"></a> [security\_groups](#input\_security\_groups) | The security groups to associate this stack to. Ensure that this security group permits traffic from sources that will be sending traffic to this cluster. Typically twitch subnets. | `list(string)` | n/a | yes |
| <a name="input_statsd_cluster_size"></a> [statsd\_cluster\_size](#input\_statsd\_cluster\_size) | The desired cluster size for statsd (statsite) | `number` | `3` | no |
| <a name="input_statsd_proxy_cluster_size"></a> [statsd\_proxy\_cluster\_size](#input\_statsd\_proxy\_cluster\_size) | The desired cluster size for statsd-proxy | `number` | `3` | no |
| <a name="input_statsd_proxy_image_tag"></a> [statsd\_proxy\_image\_tag](#input\_statsd\_proxy\_image\_tag) | The image hash/tag that will be used to run statsd-proxy | `string` | `"bootstrap"` | no |
| <a name="input_statsite_image_tag"></a> [statsite\_image\_tag](#input\_statsite\_image\_tag) | The image hash/tag that will be used to run statsite | `string` | `"8dd7750dbecee9ca5fa29469d9e223cbbcf687c3"` | no |
| <a name="input_subnets"></a> [subnets](#input\_subnets) | The subnets to deploy this stack to | `list(string)` | n/a | yes |
| <a name="input_vpc_id"></a> [vpc\_id](#input\_vpc\_id) | The VPC to deploy this stack to | `string` | n/a | yes |

### Outputs

| Name | Description |
|------|-------------|
| <a name="output_carbon_c_relay_lb"></a> [carbon\_c\_relay\_lb](#output\_carbon\_c\_relay\_lb) | The graphite endpoint for sending graphite metrics |
| <a name="output_graphite_web_private_dns_name"></a> [graphite\_web\_private\_dns\_name](#output\_graphite\_web\_private\_dns\_name) | The private dns name associated with the graphite-web VPCe service |
| <a name="output_graphite_web_vpce_service_name"></a> [graphite\_web\_vpce\_service\_name](#output\_graphite\_web\_vpce\_service\_name) | The VPCe service endpoint to link other accounts |
| <a name="output_statsd_lb"></a> [statsd\_lb](#output\_statsd\_lb) | The statsd endpoint for sending metrics to |
| <a name="output_zone"></a> [zone](#output\_zone) | DNS zone delegation information required by VidCS |
<!-- END OF PRE-COMMIT-TERRAFORM DOCS HOOK -->

## Development

On OS X, the following requirements are available via [homebrew](https://brew.sh/).

* Setup [`pre-commit`](https://pre-commit.com/#install).
* Make sure the following dependencies are installed:
  * [`pre-commit terraform`](https://github.com/antonbabenko/pre-commit-terraform#step-1)
  * [`shellcheck`](https://github.com/koalaman/shellcheck#user-content-installing)

Run `pre-commit install` to install `pre-commit` hook.

### Known Issues

You may encounter the following issues when `terraform validate` part of the `pre-commit` hook is executed:

* `terraform` AWS provider requires a region to be set when `terraform validate` is being performed. If a region not set related error is prompted, set `export AWS_REGION=us-west-2` in your current terminal session.
* A minimum `terraform init` is required to pull in the required modules for `validate` to work properly.
