module "statsd_graphite" {
  source = "git@git.xarth.tv:video-coreservices/tf-mod-statsd-graphite?ref=v1.1.1"

  region = var.region

  vpc_id          = var.vpc_id
  subnets         = var.subnets
  security_groups = var.security_groups

  owner = "video-coreservices@twitch.tv"
  team  = "vidcs"

  pagerduty_url = "https://events.pagerduty.com/integration/4c7c22b1044949a78a94b59a43131631/enqueue"

  statsd_proxy_image_tag   = var.statsd_proxy_image_tag
  statsite_image_tag       = var.statsite_image_tag
  carbon_c_relay_image_tag = var.carbon_c_relay_image_tag
  go_carbon_image_tag      = var.go_carbon_image_tag
  graphite_web_image_tag   = var.graphite_web_image_tag

  statsd_proxy_cluster_size   = var.statsd_proxy_cluster_size
  statsd_cluster_size         = var.statsd_cluster_size
  carbon_c_relay_cluster_size = var.carbon_c_relay_cluster_size
  go_carbon_cluster_size      = var.go_carbon_cluster_size
  graphite_web_cluster_size   = var.graphite_web_cluster_size
}
