# VidCS DNS Service Delegations

Configure and manages DNS delegations for VIDCS owned `<service>.live-video.a2z.com`.

## Requirements

* [tfenv](https://github.com/tfutils/tfenv#automatic)
* Isengard AWS credentials for DNS service accounts to deploy changes

## Code structure

Configuration information for each service lives under [`conf`](./conf). Each `.tfvars` should contain the name of the AWS account that the subdomain will be delegated to, and the AWS account id. E.g. [`conf/puppet/stage.us-west-2.tfvars`](./conf/puppet/stage.us-west-2.tfvars).

```hcl
subdomain_account_name = "twitch-bs-video-ops-stg"
subdomain_account_id   = "152548578290"
```

The configuration files follow the following structure: `conf/<service_name>/<env>.<region>.tfvars` to determine the subdomain name. E.g. `conf/puppet/stage.us-west-2.tfvars` will delegate `us-west-2.stage.puppet.live-video.a2z.com` subdomain to `twitch-bs-video-ops-stg` account, account id `152548578290`.

```bash
├── conf
│   ├── <service_A>
│   │   └── <env>.<region>.tfvars
│   │   └── ...
│   └── <service_B>
│   │   ├── prod.us-west-2.tfvars
│   │   ├── prod.us-east-2.tfvars
│   │   └── stage.us-west-2.tfvars
│   │   └── ...
│   └── ...
└── src
    ├── delegation
    │   ├── deploy.sh
    │   └── main.tf
    ├── iam
    │   ├── deploy.sh
    │   ├── main.tf
    └── primary
        ├── deploy.sh
        └── main.tf
```

The terraform source and deployment scripts lives under [`src`](./src). There are 3 primary different modules used for deploying new DNS subdomains, following the conventions of [`video-coreservices/tf-mod-live-video-dns-delegation`](https://git.xarth.tv/video-coreservices/tf-mod-live-video-dns-delegation).

## Subdomain Management

1. [Setting up a new `<service>.live-video.a2z.com`.](./src/primary)
1. [Setting up `lvs-dns-delegation` IAM role for `<region>.<env>.<service>.live-video.a2z.com` accounts.](./src/iam)
1. [Setting up `<region>.<env>.<service>.live-video.a2z.com` subdomains and delegations.](./src/delegation)
