# Create and Delegate subdomains

This manages the creation of `<region>.<env>.<service>.live-video.a2z.com` AWS Route53 hosted zone and delegates this subdomain from `<service>.live-video.a2z.com` domain.

## Usage

```bash
./deploy.sh -s <service> -e <env> -r <region> <command> [args]

<service>
  The name of the service. E.g. puppet

<region>
  This should be a valid AWS region. E.g. us-west-2

<env>
  This should be either dev, stage, or prod
```

E.g.

```bash
./deploy.sh -s puppet -e stage -r us-west-2 plan
```

### Adding/Modifying subdomains and delegations

To delegate a new `<region>.<env>.<service>.live-video.a2z.com` subdomain, create a new `.tfvars` file in `conf`. Refer [code structure](../../README.md#code-structure) in the primary README doc.

E.g.

```bash
$ ./deploy.sh -s puppet -e stage -r us-west-2 plan
Initializing modules...

Initializing the backend...

Successfully configured the backend "s3"! Terraform will automatically
use this backend unless the backend configuration changes.

Initializing provider plugins...

Terraform has been successfully initialized!

You may now begin working with Terraform. Try running "terraform plan" to see
any changes that are required for your infrastructure. All Terraform commands
should now work.

If you ever set or change modules or backend configuration for Terraform,
rerun this command to reinitialize your working directory. If you forget, other
commands will detect it and remind you to do so if necessary.
Refreshing Terraform state in-memory prior to plan...
The refreshed state will be used to calculate this plan, but will not be
persisted to local or remote state storage.

module.delegation.data.aws_route53_zone.primary: Refreshing state...
module.delegation.data.aws_caller_identity.account: Refreshing state...

------------------------------------------------------------------------

An execution plan has been generated and is shown below.
Resource actions are indicated with the following symbols:
  + create

Terraform will perform the following actions:

  # module.delegation.aws_route53_record.comment will be created
  + resource "aws_route53_record" "comment" {
      + allow_overwrite = (known after apply)
      + fqdn            = (known after apply)
      + id              = (known after apply)
      + name            = "_comment.us-west-2.stage.puppet.live-video.a2z.com"
      + records         = [
          + "Delegated to 152548578290 (twitch-bs-video-ops-stg)",
        ]
      + ttl             = 86400
      + type            = "TXT"
      + zone_id         = "Z1EER9K9QXA0B8"
    }

  # module.delegation.aws_route53_record.subdomain will be created
  + resource "aws_route53_record" "subdomain" {
      + allow_overwrite = (known after apply)
      + fqdn            = (known after apply)
      + id              = (known after apply)
      + name            = "us-west-2.stage.puppet.live-video.a2z.com"
      + records         = (known after apply)
      + ttl             = 86400
      + type            = "NS"
      + zone_id         = "Z1EER9K9QXA0B8"
    }

  # module.delegation.module.subdomain.aws_route53_zone.service will be created
  + resource "aws_route53_zone" "service" {
      + comment       = "Delegated by account: 678299527794"
      + force_destroy = false
      + id            = (known after apply)
      + name          = "us-west-2.stage.puppet.live-video.a2z.com"
      + name_servers  = (known after apply)
      + vpc_id        = (known after apply)
      + vpc_region    = (known after apply)
      + zone_id       = (known after apply)
    }

Plan: 3 to add, 0 to change, 0 to destroy.

------------------------------------------------------------------------

Note: You didn't specify an "-out" parameter to save this plan, so Terraform
can't guarantee that exactly these actions will be performed if
"terraform apply" is subsequently run.
```

### Example output

This is an example output of a successful run:

```
delegation = {
  "comment" = "Delegated to 152548578290 (twitch-bs-video-ops-stg)"
  "records" = [
    "ns-1269.awsdns-30.org",
    "ns-1620.awsdns-10.co.uk",
    "ns-269.awsdns-33.com",
    "ns-637.awsdns-15.net",
  ]
  "subdomain" = "us-west-2.stage.puppet.live-video.a2z.com"
  "ttl" = 86400
}
```
