variable "service" {}
variable "region" {}
variable "env" {}

variable "subdomain_account_name" {}
variable "subdomain_account_id" {}
variable "subdomain_account_role" {
  default = "lvs-dns-delegation"
}

terraform {
  required_version = "=0.12.6"

  backend "s3" {
    region         = "us-west-2"
    dynamodb_table = "terraform_locks"
  }
}

provider "aws" {
  region  = "us-west-2"
  version = "~> 2.25"
}

provider "null" {
  version = "~> 2.1"
}

module "delegation" {
  source = "git@git.xarth.tv:video-coreservices/tf-mod-live-video-dns-delegation.git//delegate?ref=v1.0.3"

  service = var.service
  region  = var.region
  env     = var.env

  subdomain_account_name = var.subdomain_account_name
  subdomain_account_id   = var.subdomain_account_id
  subdomain_account_role = var.subdomain_account_role
}

output "delegation" {
  value = module.delegation
}
