# Setup Delegation IAM Permissions

This setups up the IAM role required for delegation.

__Note__: This module _intentionally_ do not manage state file to avoid addional overhead of terraform remote state management.

This is a wrapper around [`video-coreservices/tf-mod-live-video-dns-delegation/iam`](https://git.xarth.tv/video-coreservices/tf-mod-live-video-dns-delegation/tree/master/modules/iam) module.

## Usage

Run this once on any new `<region>.<env>.<service>.live-video.a2z.com` account.

1. Obtain Isengard credentials for desired account.
1. Run the following command:

```
./deploy.sh <plan|apply>
```

note: when prompted with

```
var.delegator_account_id
  The AWS account_id that will delegate DNS subdomains
```

enter the account ID of the account that hosts the `<service>.live-video.a2z.com` subdomain.

### Party Account usage

1. Obtain Isengard credentials for desired account.
1. Set `subdomain_account_role` correctly in all conf files associated with the subdomain
1. Make sure to remove local `terraform.tfstate*` files from this directory so terraform doesn't try to replace existing roles.
1. Run the following command:

```
./deploy.sh <plan|apply> -var-file=../../conf/<your-service>/<var-file>
```

Ignore the warnings that `Role 'lvs-dns-delegation' has already been created in this AWS account!` when trying to create another role in the party account.
note: when prompted with :

```
var.delegator_account_id
  The AWS account_id that will delegate DNS subdomains
```

enter the account ID of the account that hosts the `<service>.live-video.a2z.com` subdomain. Ignore the `Value for undeclared variable` warnings.

Following this process with the party account will allow you to no override the already existing `lvs-delegation-role` that already exists in the account.
