# Run this once on any account that needs lvs-dns-delegator IAM role
variable "delegator_account_id" {
  description = "The AWS account_id that will delegate DNS subdomains"
}

variable "delegator_account_role" {
  description = "The assumed role of the AWS account_id that will create and delegate DNS subdomains"
  default     = "Admin"
}

variable "subdomain_account_role" {
  description = "The name of the role to create to allow the creation of subdomains. Overridable for party account situations"
  default     = "lvs-dns-delegation"
}

provider "aws" {
  region  = "us-west-2"
  version = "~> 2.26"
}

module "iam" {
  source = "git@git.xarth.tv:video-coreservices/tf-mod-live-video-dns-delegation.git//modules/iam?ref=v1.0.7"

  delegator_account_id   = var.delegator_account_id
  delegator_account_role = var.delegator_account_role
  subdomain_account_role = var.subdomain_account_role

  tags = {
    Environment = "prod"
    Owner       = "video-coreservices@twitch.tv"
    Src         = "video-coreservices/tf-io-vidcs-live-video-dns"
  }
}

output "iam" {
  value = module.iam
}
