# Managing service primary DNS subdomain

This code is used to manage and deploy new changes to different service primary DNS domains. (i.e. `<service>.live-video.a2z.com`)

## Additional Requirements

In addition to the [requirements](../../README.md#requirements) layout in the main README, do the following:

1. Create a [new AWS account](https://wiki.twitch.com/display/AD/How+to+Set+Up+a+New+AWS+Account) specifically to manage this DNS zone.
1. Create new `Admin` console access role:
   * Assign `Permissions` to `twitch-vidcs-group`, and `twitch-secondary-owners`.
   * Attach `AdministratorAccess` IAM policy to `Admin` role.
1. Create `S3` bucket and `DynamoDB` table for new DNS service account. This is used for Terraform state files management.
   * run `./setup_tf_state.sh -s <your_service_name> -d <live-video-a2z|live-video-net> -e (prod|staging|dev) -r <aws_region>`

## Deploy new primary service

This is a wrapper around [`video-coreservices/tf-mod-live-video-dns-delegation/primary`](https://git.xarth.tv/video-coreservices/tf-mod-live-video-dns-delegation/tree/master/primary) module.

1. Obtain Isengard credentials for the service account to plan/deploy new changes.
1. Run `./deploy.sh` script with desired arguments.

```bash
./deploy.sh -s <service_name> <plan|apply|...>

# E.g.
./deploy.sh -s puppet plan
```

### Example output

This is an example of a successful output. `account_id` and `account_role` is required for [IAM](../iam) module to setup new IAM roles for `<region>.<env>.<service.live-video.a2z.com` accounts.

```bash
service = {
  "account_id" = "678299527794"
  "account_role" = "Admin"
  "primary" = {
    "zone" = {
      "id" = "Z1EER9K9QXA0B8"
      "name" = "puppet.live-video.a2z.com"
      "name_servers" = [
        "ns-1100.awsdns-09.org",
        "ns-2020.awsdns-60.co.uk",
        "ns-411.awsdns-51.com",
        "ns-554.awsdns-05.net",
      ]
    }
  }
}
```

## Notes

Terraform state and locks are stored in the AWS account that hosts `<service>.live-video.a2z.com`.

## Nice-to-haves

* [ ] Automate new AWS account creation for managing DNS zone.
* [ ] Automate new S3 bucket and DynamoDB table creation for new DNS service accounts. This is used for storing Terraform state files.
