#!/usr/bin/env bash

set -eo pipefail

usage() {
    echo "Usage: $0 -s <service> <command> [args]"
    exit 1
}

requirements() {
    command -v tfenv &> /dev/null || ( echo "tfenv required but missing" && usage )
}

tf_init() {
    shift
    terraform init "$@" -reconfigure -backend-config=<(cat <<EOF
key    = "primary/${service}.tfstate"
bucket = "${service}-live-video-a2z-dns-tf-state"
EOF
)
}

if [[ "$1" == "-s" ]]; then
    service="$2"
    shift 2

    # check_service_exist
    requirements

    case "$1" in
        init)
            tf_init "$@"
            ;;
        plan|apply)
            tf_init "$@"
            exec terraform "$@" \
                -var="service=${service}"
            ;;
        *)
            exec terraform "$@"
            ;;
    esac
else
    usage
fi
