variable "service" {
  description = "The name of the service"
}

provider "aws" {
  region  = "us-west-2"
  version = "~> 2.25"
}

terraform {
  required_version = "=0.12.6"

  backend "s3" {
    region         = "us-west-2"
    dynamodb_table = "terraform_locks"
  }
}

module "service" {
  source  = "git@git.xarth.tv:video-coreservices/tf-mod-live-video-dns-delegation.git//primary?ref=v1.0.0"
  service = var.service

  comment = "${title(var.service)} Service Primary DNS"

  tags = {
    Owner       = "video-coreservices@twitch.tv"
    Environment = "prod"
    Src         = "video-coreservices/tf-io-vidcs-live-video-dns"
  }
}

output "service" {
  value = module.service
}
