#!/usr/bin/env bash
domain="live-video-a2z"
service=""
ENV="staging"
REGION="us-west-2"

while getopts ":d:s:e:r:" opt; do
  case ${opt} in
    d )
      domain=$OPTARG
      ;;
    s )
      service=$OPTARG
      ;;
    e )
      ENV=$OPTARG
      ;;
    r )
      REGION=$OPTARG
      ;;
    \? )
      echo "Usage: $0 [ -d live-video-a2z|live-video-net ][ -s <servicename> ][ -e prod|staging ][ -r <aws_region> ]" 1>&2
      exit 1
      ;;
  esac
done

bucketname="${service}-${domain}-dns-tf-state"

aws s3 mb --region="$REGION" s3://"$bucketname"
aws s3api put-bucket-versioning --bucket "$bucketname" --versioning-configuration Status=Enabled
aws s3api put-public-access-block --bucket "$bucketname" --public-access-block-configuration BlockPublicAcls=True,IgnorePublicAcls=True,BlockPublicPolicy=True,RestrictPublicBuckets=True
aws s3api put-bucket-encryption --bucket "$bucketname" --server-side-encryption-configuration '{"Rules": [{"ApplyServerSideEncryptionByDefault": {"SSEAlgorithm": "AES256"}}]}'
aws s3api put-bucket-tagging --bucket "$bucketname" --tagging "TagSet=[{Key=Owner,Value=video-coreservices@twitch.tv}, {Key=Environment,Value=${ENV}}, {Key=Service,Value=${service}}]"

aws dynamodb create-table --cli-input-json file://terraform_locks.json --region="$REGION"
